/*
 * Decompiled with CFR 0.152.
 */
package de.ddb.charset;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class EightBitCharset
extends Charset {
    public EightBitCharset() {
        super("8-Bit-Charset", null);
    }

    public boolean contains(Charset charset) {
        return false;
    }

    public CharsetDecoder newDecoder() {
        return new CharToByteConverter(this);
    }

    public CharsetEncoder newEncoder() {
        return new ByteToCharConverter(this);
    }

    class ByteToCharConverter
    extends CharsetEncoder {
        protected ByteToCharConverter(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            while (charBuffer.remaining() > 0) {
                try {
                    byteBuffer.put((byte)charBuffer.get());
                }
                catch (BufferOverflowException bufferOverflowException) {
                    charBuffer.position(charBuffer.position() - 1);
                    return CoderResult.OVERFLOW;
                }
            }
            return CoderResult.UNDERFLOW;
        }
    }

    class CharToByteConverter
    extends CharsetDecoder {
        protected CharToByteConverter(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            while (byteBuffer.remaining() > 0) {
                try {
                    charBuffer.put((char)(byteBuffer.get() & 0xFF));
                }
                catch (BufferOverflowException bufferOverflowException) {
                    byteBuffer.position(byteBuffer.position() - 1);
                    return CoderResult.OVERFLOW;
                }
            }
            return CoderResult.UNDERFLOW;
        }
    }
}

