/*
 * Decompiled with CFR 0.152.
 */
package de.ddb.charset;

import de.ddb.charset.MabCharset;
import de.ddb.charset.MabDisketteCharset;
import de.ddb.charset.PicaCharset;
import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CharsetUtil
extends CharsetProvider {
    private static final Log logger = LogFactory.getLog(CharsetUtil.class);
    private static PicaCharset PICA_CHARSET = new PicaCharset();
    private static MabCharset MAB_CHARSET = new MabCharset();
    private static MabDisketteCharset MAB_DISKETTE_CHARSET = new MabDisketteCharset();

    public static final Charset forName(String string) {
        if (CharsetUtil.charsetHasCharsetName(PICA_CHARSET, string)) {
            return PICA_CHARSET;
        }
        if (CharsetUtil.charsetHasCharsetName(MAB_CHARSET, string)) {
            return MAB_CHARSET;
        }
        if (CharsetUtil.charsetHasCharsetName(MAB_DISKETTE_CHARSET, string)) {
            return MAB_DISKETTE_CHARSET;
        }
        return Charset.forName(string);
    }

    public static PicaCharset getPicaCharset() {
        return PICA_CHARSET;
    }

    public static MabCharset getMabCharset() {
        return MAB_CHARSET;
    }

    public static boolean charsetHasCharsetName(Charset charset, String string) {
        if (charset.name().equals(string)) {
            return true;
        }
        if (charset.aliases() != null) {
            for (String string2 : charset.aliases()) {
                if (!string2.equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public Iterator charsets() {
        ArrayList<Charset> arrayList = new ArrayList<Charset>(2);
        arrayList.add(PICA_CHARSET);
        arrayList.add(MAB_CHARSET);
        arrayList.add(MAB_DISKETTE_CHARSET);
        return arrayList.iterator();
    }

    public Charset charsetForName(String string) {
        if (CharsetUtil.charsetHasCharsetName(PICA_CHARSET, string)) {
            return PICA_CHARSET;
        }
        if (CharsetUtil.charsetHasCharsetName(MAB_CHARSET, string)) {
            return MAB_CHARSET;
        }
        if (CharsetUtil.charsetHasCharsetName(MAB_DISKETTE_CHARSET, string)) {
            return MAB_DISKETTE_CHARSET;
        }
        return null;
    }
}

